// models/associations.js
import User from './user.js';
import Entidad from './entidad.js';
import Cargo from './cargo.js';
import Ciudad from './ciudad.js';
import Contacto from './contacto.js';
import Departamento from './departamento.js';
import Reto from './reto.js';
import AplicarReto from './aplicarReto.js';
import UsuarioEmpresaCargo from './usuarioEmpresaCargo.js';
import Clasificado from './clasificado.js';
import ContactarSolicitud from './contactarSolicitudServicio.js';
// Definir todas las asociaciones aquí

User.hasMany(UsuarioEmpresaCargo, { foreignKey: 'userId' });
Entidad.hasMany(UsuarioEmpresaCargo, { foreignKey: 'empresaId' });
Cargo.hasMany(UsuarioEmpresaCargo, { foreignKey: 'cargoId' });

Ciudad.hasMany(Entidad, { foreignKey: 'ciudadId' });
Contacto.hasMany(Entidad, { foreignKey: 'contactoId' });
Departamento.hasMany(Ciudad, { foreignKey: 'departamentoId' });

Reto.hasMany(AplicarReto, { foreignKey: 'retoId' });
Entidad.hasMany(AplicarReto, { foreignKey: 'entidadId' });

User.hasMany(Clasificado, { foreignKey: 'providerId' });

Clasificado.hasMany(ContactarSolicitud, { foreignKey: 'clasificadoId' });
User.hasMany(ContactarSolicitud, { foreignKey: 'userId' });
export default () => {
  // Esto asegura que las asociaciones se definan solo una vez
  User.sync();
  Entidad.sync();
  Cargo.sync();
  Ciudad.sync();
  Departamento.sync();
  Contacto.sync();
  Reto.sync();
  AplicarReto.sync();
  Clasificado.sync();
  UsuarioEmpresaCargo.sync();
};
