let empresaC = 0;
let startupC = 0;
let emprendimientoC = 0;
let universidadesC = 0;
let todasLasEmpresas = [];

document.addEventListener("DOMContentLoaded", function () {
    // Realizar la petición para obtener las empresas
    fetch(`${API_BASE_URL}/api/entidad/entidadHabilitadas`)
        .then(response => response.json())
        .then(data => {
            if (data.success && data.empresas.length > 0) {
                // Llamamos a la función para cargar las empresas
                todasLasEmpresas = data.empresas; // Guardar todas
                cargarEmpresas(data.empresas);
            } else {
                console.log(data.mensaje || 'No hay empresas habilitadas.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
});

// Función para cargar las empresas dinámicamente
function cargarEmpresas(empresas) {
    const listado = document.getElementById('listado');
    listado.innerHTML = '';  // Limpiar el contenido previo
    empresaC = 0;
    startupC = 0;
    emprendimientoC = 0;
    universidadesC = 0;
    empresas.forEach(empresa => {
        if (empresa.habilitado == 1) {
       
        const empresaCard = document.createElement('div');
        empresaCard.classList.add('cardinfo');
        let rutaCompleta = empresa.logo;
        empresaCard.innerHTML = `
            <img src="/logos/${rutaCompleta}" alt="Logo Empresa" class="card-icon">
            <h3 class="card-title">${empresa.razonSocial}</h3>
            <p class="card-text">${empresa.actividadEconomica}</p>
        <button class="botonEntidad" id="masinfo${empresa.numIdentificacion}" ">Mas informacion</button>

        `;
 
        listado.appendChild(empresaCard);

        switch (empresa.claseEntidad) {
            case "Empresa":
                empresaC++;
                break;
            case "Emprendimiento":
                emprendimientoC++;
                break;
            case "Startup":
                startupC++;
                break;
            case "Universidad":
                universidadesC++;
                break;

            default:
                break;
        }

    }
    });
    
    if (empresas.length==0){
        const empresaCard = document.createElement('div');
            empresaCard.classList.add('cardinfo');
     
            empresaCard.innerHTML = `
                <img src="/logos/sindatos.jpg" alt="Logo Empresa" class="card-icon">
                <h3 class="card-title">0 entidades </h3>
            `;
            listado.appendChild(empresaCard);
    }
   
    document.getElementById("empresaC").innerText = empresaC;
    document.getElementById("emprendiminetoC").innerText = emprendimientoC;
    document.getElementById("startupC").innerText = startupC;
    document.getElementById("universidadesC").innerText = universidadesC;

}


document.addEventListener('DOMContentLoaded', function () {
    // Abrir modal con info de la empresa
    document.addEventListener('click', function (e) {
      if (e.target && e.target.classList.contains('botonEntidad')) {
        console.log(todasLasEmpresas)

        const id = e.target.id.replace('masinfo', '');
        console.log(todasLasEmpresas)
        const empresa = todasLasEmpresas.find(emp => emp.numIdentificacion === id);
        console.log(empresa)
  
        if (empresa) {
          document.getElementById('modalRazonSocial').textContent = empresa.razonSocial;
          document.getElementById('modalActividad').textContent = empresa.actividadEconomica;
          document.getElementById('modalIdentificacion').textContent = empresa.numIdentificacion;
  
          document.getElementById('empresaModal').style.display = 'block';
        }
      }
    });
  
    // Cerrar modal al hacer click en la X
    document.querySelector('.close').onclick = function () {
      document.getElementById('empresaModal').style.display = 'none';
    };
  
    // Cerrar modal si se hace click fuera del contenido
    window.onclick = function (event) {
      if (event.target === document.getElementById('empresaModal')) {
        document.getElementById('empresaModal').style.display = 'none';
      }
    };
  });
