// /api/user

import express from 'express';
import User from '../models/user.js'; // Asegúrate de tener un modelo de usuario definido
import { methods as authorization } from "../middlewares/authorization.js";

import {
  countUsers,
  getAllUsers,
  getUserEmailById,
  updateUser,
  deleteUser,
  deleteUserWithEntidades
} from '../controllers/userController.js';

const router = express.Router();

router.get('/count', countUsers);
router.get('/', getAllUsers);
router.get('/email/:id', getUserEmailById);
router.put('/:id', authorization.soloAdmin, updateUser);
router.delete('/:id', authorization.soloAdmin, deleteUser);
router.delete('/:id/with-entidades', authorization.soloAdmin, deleteUserWithEntidades);

export default router;