// upload.js
import multer from 'multer';
import path from 'path';
import { v4 as uuidv4 } from 'uuid'; // Importar para generar identificadores únicos
import fs from 'fs';

// Almacenamiento personalizado
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    // Guardar archivos en carpetas distintas según el campo
    if (file.fieldname === 'video') {
      cb(null, 'app/public/videos');
    } else if (file.fieldname === 'ficha') {
      cb(null, 'app/public/fichas');
        } else if (file.fieldname.startsWith('file')) {
            console.log('file', req.body['challenge-id']);
      const retoId = req.body['challenge-id'] || 'defaultReto';
      const retoPath = path.join('app/public/datosRetos', retoId);

      // Crear carpeta si no existe
      if (!fs.existsSync(retoPath)) {
        fs.mkdirSync(retoPath, { recursive: true });
      }
      cb(null, retoPath);
        } else {
      cb(null, 'app/public/logos'); // Carpeta donde se guardarán los archivos
    }
  },

  filename: (req, file, cb) => {
    // Generar un nombre único para el archivo
    const uniqueId = req.body.id || uuidv4(); // Usar el ID de la base de datos o generar uno único
    cb(null, `${uniqueId}${path.extname(file.originalname)}`);
  }
});

// Filtro de archivos permitidos
const fileFilter = (req, file, cb) => {
  const allowedTypes = /jpeg|jpg|png|gif|mp4|pdf/;
  const extname = allowedTypes.test(path.extname(file.originalname).toLowerCase());
  const mimetype = allowedTypes.test(file.mimetype);

  if (extname && mimetype) {
    cb(null, true);
  } else {
    cb(new Error('Tipo de archivo no permitido (solo imágenes, mp4 o PDF)'));
  }
};

// Configuración Multer
const upload = multer({
  storage,
  fileFilter,
  limits: { fileSize: 10 * 1024 * 1024 }, // Máximo 10MB
});

export default upload;
