import UserEntityCargo from '../models/UsuarioEmpresaCargo.js';

export const assignUserToEntityAndCargo = async (req, res) => {
    try {
        const { userId, empresaId, cargoId } = req.body;

        if (!userId || !empresaId || !cargoId) {
            return res.status(400).json({ message: 'Faltan datos requeridos' });
        }

        const assignment = new UserEntityCargo({
            userId,
            empresaId,
            cargoId
        });

        const savedAssignment = await assignment.save();
        res.status(201).json(savedAssignment);
    } catch (error) {
        res.status(500).json({ message: 'Error al asignar usuario, entidad y cargo', error });
    }
};