import { DataTypes } from 'sequelize';
import sequelize from '../config/database.js';  // Asegúrate de que la instancia de Sequelize está importada correctamente
import User from './user.js';
import Empresa from './entidad.js';
import Cargo from './cargo.js';

const UsuarioEmpresaCargo = sequelize.define('UsuarioEmpresaCargo', {
  userId: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: {
      model: 'Users',  // Nombre de la tabla de usuarios
      key: 'id',
    },
  },
  empresaId: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: {
      model: 'Entidad',  // Nombre de la tabla de empresas
      key: 'id',
    },
  },
  cargoId: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: {
      model: 'Cargos',  // Nombre de la tabla de cargos
      key: 'id',
    },
  },
}, {
  tableName: 'UsuarioEmpresaCargo',  // Nombre de la tabla intermedia
  timestamps: false,  // Si no quieres que se generen campos de timestamps (createdAt y updatedAt)
});

export default UsuarioEmpresaCargo;
