import { DataTypes } from 'sequelize';
import sequelize from '../config/database.js';  // Importa la instancia de Sequelize

const Cargo = sequelize.define('Cargo', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      name: {
        type: DataTypes.STRING,
        allowNull: false,
      },
}, {
    timestamps: false, // Esto habilita los campos `createdAt` y `updatedAt`
    
  });

// Relación uno a uno con Empresa

export default Cargo;
