import express from 'express';
import { getRetos, createReto, aplicarReto ,verificarAplicacion} from '../controllers/retosController.js';

const router = express.Router();

// GET route to fetch all retos
router.get('/', getRetos);

// POST route to create a new reto
router.post('/', createReto);
router.post('/aplicar', aplicarReto); // Alias for creating a reto
// POST route to check if a user has already applied to a reto
router.get('/verificar-aplicacion', async (req, res) => {
    const { entidadId, retoId } = req.query;

    // Logic to check if the entity has already applied to the reto
    if (!entidadId || !retoId) {
        return res.status(400).json({ message: 'entidadId and retoId are required' });
    }

    try {
        // Example: Call a function from the controller to verify the application
        const aplicado = await verificarAplicacion(entidadId, retoId);
        res.status(200).json({ aplicado });
    } catch (error) {
        res.status(500).json({ message: 'Error verifying application', error });
    }
});
export default router;